(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      6786,        227]*)
(*NotebookOutlinePosition[      7429,        249]*)
(*  CellTagsIndexPosition[      7385,        245]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \(sumcuad[n_] := Apply[Plus, \ IntegerDigits[n]^2]\)], "Input"],

Cell[BoxData[
    \(MatrixForm[Table[NestList[sumcuad, \ k, \ 15], \ {k, 100}]]\)], "Input"],

Cell[BoxData[{
    \(\(test[x_List] := \ "\<punto fijo\>" /; \ MemberQ[x, 1];\)\), "\n", 
    \(\(test[x_List] := \ "\<per\[IAcute]odo 8\>" /; \ 
          MemberQ[x, 145];\)\), "\n", 
    \(\(test[x_List] := \ "\<ni lo uno ni lo otro\>";\)\)}], "Input"],

Cell[BoxData[
    \(datos30\  = \ 
      Map[test, \ 
        Table[NestList[sumcuad, \ k, \ 15], \ {k, \ 30}]]\)], "Input"],

Cell[BoxData[
    \(\(datos100\  = \ 
        Map[test, \ 
          Table[NestList[sumcuad, \ k, \ 15], \ {k, \ 100}]];\)\)], "Input"],

Cell[BoxData[
    \(Cases[datos100, \ "\<ni lo uno ni lo otro\>"]\)], "Input"],

Cell[BoxData[
    \(Count[datos100, \ "\<punto fijo\>"]\)], "Input"],

Cell[BoxData[
    \(\(aleat\  = \ 
        Table[Random[Integer, \ {10^999, \ 10^1000}], {100}];\)\)], "Input"],

Cell[BoxData[
    \(\(datosaleat\  = \ 
        Map[test, \ 
          Table[NestList[sumcuad, \ aleat[\([k]\)], \ 15], \ {k, 
              100}]];\)\)], "Input"],

Cell[BoxData[
    \(Cases[datosaleat, \ "\<ni lo uno ni lo otro\>"]\)], "Input"],

Cell[BoxData[
    \(Count[datosaleat, \ "\<punto fijo\>"]\)], "Input"],

Cell[BoxData[
    \(sumcuad[999]\)], "Input"],

Cell[BoxData[
    \(sumcuad[9999]\)], "Input"],

Cell[BoxData[
    \(f[n_] := \ Log[10, \ \(10^n\  - \ 1\)\/\(81*n\)]\)], "Input"],

Cell[BoxData[
    \(Table[N[f[n]], \ {n, \ 10}]\)], "Input"],

Cell[BoxData[
    \(Plot[{1, f[x]}, {x, 1, 5}]\)], "Input"],

Cell[BoxData[
    \(\(f'\)[x]\)], "Input"],

Cell[BoxData[
    \(FullSimplify[%]\)], "Input"],

Cell[BoxData[
    \(Cases[
      Map[test, \ 
        Table[NestList[sumcuad, \ k, \ 15], \ {k, \ 
            243}]], \ "\<ni lo uno ni lo otro\>"]\)], "Input"],

Cell[CellGroupData[{

Cell["Ejercicio 1", "Section"],

Cell[BoxData[
    \(n1 = Ceiling[9999/81]\)], "Input"],

Cell[BoxData[
    \( (*\ 
      Para\ que\ al\ aplicar\ sumcuad\ una\ vez\ y\ alcanzar\ un\ \
n\[UAcute]mero\ mayor\ de\ 9999\ necesito\ un\ n\[UAcute]mero\ con\ al\ menos\
\ 124\ d\[IAcute]gitos\ \((nueves)\)\ *) \)], "Input"],

Cell[BoxData[
    \( (*\ 
      El\ siguiente\ n\[UAcute]mero\ tendr\[IAcute]a\ que\ tener\ n\ d\
\[IAcute]gitos\ iguales\ a\ 9\ donde\ n\ tiene\ que\ cumplir\ que\ \ 81*
          n\  > \ 10^n1\  - \ 1\ *) \)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 2", "Section"],

Cell[BoxData[
    \(sum4[n_] := \ Apply[Plus, \ IntegerDigits[n]^4]\)], "Input"],

Cell[BoxData[
    \(\(A4\  = \ Table[NestList[sum4, \ k, \ 60], \ {k, 100}];\)\)], "Input"],

Cell[BoxData[
    \(sum5[n_] := \ Apply[Plus, \ IntegerDigits[n]^5]\)], "Input"],

Cell[BoxData[
    \(\(A5\  = \ Table[NestList[sum5, \ k, \ 80], \ {k, 100}];\)\)], "Input"],

Cell[BoxData[
    \(datciclo[x_List] := 
      Module[{salida = False}, 
        For[i\  = \ 1, \((i\  <= \ Length[x] && \((salida\  == False)\))\), \ 
          i\  = \ i + 1, \n\t
          For[k\  = \ i + 1, \ k\  <= \ Length\ [x], \ k\  = \ k + 1, 
            If[x[\([i]\)] == x[\([k]\)], salida\  = \ True; Break[]]\ \ ]]; 
        Print["\<Ciclo de orden \>", \ k - i + 1, "\< en el lugar \>", 
          i - 1, \ "\< valor inicial \>", \ x[\([i - 1]\)]]]\)], "Input"],

Cell[BoxData[
    \(Do[datciclo[A4[\([k]\)]], {k, 25}]\)], "Input"],

Cell[BoxData[
    \(Do[datciclo[A5[\([k]\)]], {k, 25}]\)], "Input"],

Cell[BoxData[
    \(listdatciclo[x_List] := 
      Module[{salida = False}, 
        For[i\  = \ 1, \((i\  <= \ Length[x] && \((salida\  == False)\))\), \ 
          i\  = \ i + 1, \n\t
          For[k\  = \ i + 1, \ k\  <= \ Length\ [x], \ k\  = \ k + 1, 
            If[x[\([i]\)] == x[\([k]\)], salida\  = \ True; 
              Break[]]\ \ ]]; {i - 1, k - i + 1, x[\([i - 1]\)]}]\)], "Input"],

Cell[BoxData[
    \(ciclo[x_List] := 
      Table[x[\([k]\)], {k, \(listdatciclo[
              x]\)[\([1]\)], \(listdatciclo[x]\)[\([1]\)] + \(listdatciclo[
                x]\)[\([2]\)] - 1}]\)], "Input"],

Cell[BoxData[
    \(beginciclo[x_List] := \(listdatciclo[x]\)[\([3]\)]\)], "Input"],

Cell[BoxData[
    \(datciclo[A4[\([32]\)]]\)], "Input"],

Cell[BoxData[
    \(ciclo[A4[\([32]\)]]\)], "Input"],

Cell[BoxData[
    \(datciclo[A4[\([66]\)]]\)], "Input"],

Cell[BoxData[
    \(ciclo[A4[\([66]\)]]\)], "Input"],

Cell["\<\
  A4[[66]]  tiene un ciclo de  orden 2  en los dem\[AAcute]s casos, o bien \
hay un punto fijo que puede ser 1 o 8208, o hay un ciclo de orden 7 cuyo \
valor m\[AAcute]s peque\[NTilde]o es 1138.\
\>", "Text"],

Cell[BoxData[
    \(ciclos4 = Union[Table[ciclo[A4[\([k]\)]], {k, 100}]]\)], "Input"],

Cell[BoxData[
    \(valortest4 = Union[Flatten[ciclos4]]\)], "Input"],

Cell[BoxData[
    \(longciclos4 = 
      Table[Length[ciclos4[\([k]\)]], {k, Length[ciclos4]}]\)], "Input"],

Cell[BoxData[
    \(ciclos5 = Union[Table[ciclo[A5[\([k]\)]], {k, 100}]]\)], "Input"],

Cell[BoxData[
    \(longciclos5 = 
      Table[Length[ciclos5[\([k]\)]], {k, Length[ciclos5]}]\)], "Input"]
}, Open  ]]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 680}},
WindowSize->{673, 483},
WindowMargins->{{0, Automatic}, {Automatic, 0}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 81, 1, 30, "Input"],
Cell[1789, 53, 92, 1, 30, "Input"],
Cell[1884, 56, 254, 4, 70, "Input"],
Cell[2141, 62, 124, 3, 30, "Input"],
Cell[2268, 67, 135, 3, 30, "Input"],
Cell[2406, 72, 78, 1, 30, "Input"],
Cell[2487, 75, 68, 1, 30, "Input"],
Cell[2558, 78, 111, 2, 30, "Input"],
Cell[2672, 82, 163, 4, 30, "Input"],
Cell[2838, 88, 80, 1, 30, "Input"],
Cell[2921, 91, 70, 1, 30, "Input"],
Cell[2994, 94, 45, 1, 30, "Input"],
Cell[3042, 97, 46, 1, 30, "Input"],
Cell[3091, 100, 81, 1, 42, "Input"],
Cell[3175, 103, 60, 1, 30, "Input"],
Cell[3238, 106, 59, 1, 30, "Input"],
Cell[3300, 109, 42, 1, 30, "Input"],
Cell[3345, 112, 48, 1, 30, "Input"],
Cell[3396, 115, 161, 4, 50, "Input"],

Cell[CellGroupData[{
Cell[3582, 123, 30, 0, 59, "Section"],
Cell[3615, 125, 54, 1, 30, "Input"],
Cell[3672, 128, 227, 4, 50, "Input"],
Cell[3902, 134, 220, 4, 50, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4159, 143, 30, 0, 59, "Section"],
Cell[4192, 145, 80, 1, 30, "Input"],
Cell[4275, 148, 91, 1, 30, "Input"],
Cell[4369, 151, 80, 1, 30, "Input"],
Cell[4452, 154, 91, 1, 30, "Input"],
Cell[4546, 157, 475, 8, 130, "Input"],
Cell[5024, 167, 67, 1, 30, "Input"],
Cell[5094, 170, 67, 1, 30, "Input"],
Cell[5164, 173, 396, 7, 90, "Input"],
Cell[5563, 182, 206, 4, 70, "Input"],
Cell[5772, 188, 83, 1, 30, "Input"],
Cell[5858, 191, 55, 1, 30, "Input"],
Cell[5916, 194, 52, 1, 30, "Input"],
Cell[5971, 197, 55, 1, 30, "Input"],
Cell[6029, 200, 52, 1, 30, "Input"],
Cell[6084, 203, 218, 4, 52, "Text"],
Cell[6305, 209, 85, 1, 30, "Input"],
Cell[6393, 212, 69, 1, 30, "Input"],
Cell[6465, 215, 107, 2, 30, "Input"],
Cell[6575, 219, 85, 1, 30, "Input"],
Cell[6663, 222, 107, 2, 30, "Input"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

